<?php
session_start();
$newsFile = "news.json";
$reviewsFile = "reviews.json";
$password = "044M@Y"; // لطفاً پس از نصب رمز را تغییر دهید

// ورود
if (isset($_POST['login'])) {
    if ($_POST['password'] === $password) {
        $_SESSION['admin'] = true;
    } else {
        $error = "رمز عبور اشتباه است!";
    }
}

// خروج و هدایت
if (isset($_GET['logout'])) {
    session_destroy();
    $redirect = isset($_GET['redirect']) ? $_GET['redirect'] : "admin.php";
    header("Location: $redirect");
    exit;
}

// افزودن خبر / مسابقه
if (isset($_SESSION['admin']) && isset($_POST['addNews'])) {
    $title = trim($_POST['title']);
    $content = trim($_POST['content']);
    $color = $_POST['color'];
    $date = date("Y/m/d");

    // آپلود عکس
    $imagePath = "";
    if (!empty($_FILES['image']['name'])) {
        $targetDir = "upload/";
        if (!is_dir($targetDir)) mkdir($targetDir, 0755, true);
        $safeName = time() . "_" . basename($_FILES["image"]["name"]);
        $targetFile = $targetDir . $safeName;
        move_uploaded_file($_FILES["image"]["tmp_name"], $targetFile);
        $imagePath = $targetFile;
    }

    $newsData = file_exists($newsFile) ? json_decode(file_get_contents($newsFile), true) : [];
    if (!is_array($newsData)) $newsData = [];

    $newsData[] = [
        "title" => $title,
        "content" => $content,
        "color" => $color,
        "date" => $date,
        "image" => $imagePath
    ];

    file_put_contents($newsFile, json_encode($newsData, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    header("Location: admin.php");
    exit;
}

// حذف خبر
if (isset($_SESSION['admin']) && isset($_GET['delete'])) {
    $id = (int) $_GET['delete'];
    if (file_exists($newsFile)) {
        $newsData = json_decode(file_get_contents($newsFile), true);
        if (isset($newsData[$id])) {
            if (!empty($newsData[$id]['image']) && file_exists($newsData[$id]['image'])) {
                @unlink($newsData[$id]['image']);
            }
            unset($newsData[$id]);
            $newsData = array_values($newsData);
            file_put_contents($newsFile, json_encode($newsData, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
        }
    }
    header("Location: admin.php");
    exit;
}

// مدیریت نظرات: تأیید و حذف
$reviews = file_exists($reviewsFile) ? json_decode(file_get_contents($reviewsFile), true) : [];
if (isset($_GET['approve_review'])) {
    $id = (int) $_GET['approve_review'];
    if (isset($reviews[$id])) {
        $reviews[$id]['approved'] = true;
        file_put_contents($reviewsFile, json_encode($reviews, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
    header("Location: admin.php");
    exit;
}
if (isset($_GET['delete_review'])) {
    $id = (int) $_GET['delete_review'];
    if (isset($reviews[$id])) {
        unset($reviews[$id]);
        $reviews = array_values($reviews);
        file_put_contents($reviewsFile, json_encode($reviews, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
    header("Location: admin.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>پنل مدیریت - مصلی امام خمینی (ره) میاندوآب</title>
<script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
<div class="container mx-auto mt-10">

<?php if (!isset($_SESSION['admin'])): ?>
    <!-- فرم ورود -->
    <form method="post" class="bg-white p-6 shadow rounded w-96 mx-auto">
        <h2 class="text-xl font-bold mb-4">ورود مدیریت</h2>
        <?php if (!empty($error)) echo "<p class='text-red-500 mb-2'>".htmlspecialchars($error)."</p>"; ?>
        <input type="password" name="password" class="w-full border p-2 mb-4" placeholder="رمز عبور">
        <button type="submit" name="login" class="bg-purple-600 text-white px-4 py-2 rounded">ورود</button>
    </form>
<?php else: ?>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold">پنل مدیریت سایت</h2>
        <div class="flex gap-2">
            <!-- بازگشت به صفحه اصلی و خروج همزمان -->
            <a href="admin.php?logout=1&redirect=index.php" class="bg-blue-600 text-white px-3 py-1 rounded">بازگشت به صفحه اصلی</a>
          
        </div>
    </div>

    <!-- فرم افزودن خبر / مسابقه -->
    <form method="post" enctype="multipart/form-data" class="bg-white p-6 shadow rounded mb-6">
        <h3 class="text-xl font-bold mb-4">افزودن خبر یا مسابقه جدید</h3>
        <input type="text" name="title" class="w-full border p-2 mb-2" placeholder="عنوان" required>
        <textarea name="content" class="w-full border p-2 mb-2" placeholder="متن" required></textarea>
        <select name="color" class="w-full border p-2 mb-2">
            <option value="green-500">سبز</option>
            <option value="blue-500">آبی</option>
            <option value="red-500">قرمز</option>
            <option value="yellow-500">زرد</option>
            <option value="purple-500">بنفش</option>
        </select>
        <input type="file" name="image" class="mb-2">
        <button type="submit" name="addNews" class="bg-green-600 text-white px-4 py-2 rounded">افزودن</button>
    </form>

    <!-- مدیریت نظرات -->
    <div class="mb-10">
        <h3 class="text-xl font-bold mb-4">مدیریت نظرات کاربران</h3>
        <?php if (empty($reviews)): ?>
            <p class="text-gray-600">هیچ نظری ثبت نشده است.</p>
        <?php else: ?>
            <?php foreach ($reviews as $i => $r): ?>
                <div class="bg-white p-4 shadow rounded mb-3 border-r-4 <?= !empty($r['approved']) ? 'border-green-500' : 'border-yellow-500' ?>">
                    <b><?= htmlspecialchars($r['name']) ?> <?= !empty($r['approved']) ? '⭐ ادمین' : '' ?></b>
                    <span class="text-gray-500 text-sm">(<?= htmlspecialchars($r['date']) ?>)</span>
                    <p class="mt-2"><?= nl2br(htmlspecialchars($r['message'])) ?></p>
                    <span class="text-xs text-gray-500 ml-2">(<?= htmlspecialchars($r['type']) ?>)</span>
                    <div class="mt-3 flex gap-2">
                        <?php if (empty($r['approved'])): ?>
                            <a href="?approve_review=<?= $i ?>" class="bg-green-600 text-white px-3 py-1 rounded">تأیید</a>
                        <?php endif; ?>
                        <a href="?delete_review=<?= $i ?>" class="bg-red-600 text-white px-3 py-1 rounded">حذف</a>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <!-- مدیریت اخبار -->
    <div>
        <h3 class="text-xl font-bold mb-4">مدیریت اخبار و مسابقات</h3>
        <?php
        $newsData = file_exists($newsFile) ? json_decode(file_get_contents($newsFile), true) : [];
        if (!empty($newsData)):
            foreach ($newsData as $id => $news):
        ?>
                <div class="bg-white p-4 shadow rounded mb-3 flex justify-between items-center">
                    <div><b><?= htmlspecialchars($news['title']) ?></b> - <?= htmlspecialchars($news['date']) ?></div>
                    <a href="?delete=<?= $id ?>" class="bg-red-500 text-white px-3 py-1 rounded ml-2">حذف</a>
                </div>
        <?php
            endforeach;
        else:
            echo "<p class='text-gray-600'>فعلاً خبری ثبت نشده است.</p>";
        endif;
        ?>
    </div>
<?php endif; ?>

</div>
</body>
</html>
