<?php
session_start();

// فایل نظرات
$reviewsFile = "reviews.json";
$reviews = file_exists($reviewsFile) ? json_decode(file_get_contents($reviewsFile), true) : [];

// ثبت نظر جدید
if (isset($_POST['submit_review'])) {
    $name = trim($_POST['name']);
    $message = trim($_POST['message']);
    $type = trim($_POST['type']); // نظر یا مسابقه
    $date = date("Y/m/d");

    if ($name && $message) {
        $reviews[] = [
            "name" => $name,
            "message" => $message,
            "type" => $type,
            "date" => $date,
            "approved" => false // بعد از تایید ادمین نمایش داده می‌شود
        ];
        file_put_contents($reviewsFile, json_encode($reviews, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
        $success = "نظر شما با موفقیت ثبت شد و پس از تأیید نمایش داده می‌شود.";
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>ارتباط با ما - مصلی امام خمینی (ره) میاندوآب</title>
<script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">

<div class="container mx-auto mt-10">

    <h1 class="text-3xl font-bold mb-6 text-center">ارتباط با ما</h1>

    <!-- دکمه‌های شبکه‌های اجتماعی -->
    <div class="flex justify-center gap-4 mb-10">
        <a href="https://eitaa.com/emamjomem2b" target="_blank"
           class="bg-green-500 text-white px-6 py-3 rounded shadow hover:bg-green-600 transition">
            ایتا
        </a>
        <a href="https://instagram.com/emam.jomem2b" target="_blank"
           class="bg-pink-500 text-white px-6 py-3 rounded shadow hover:bg-pink-600 transition">
            اینستاگرام
        </a>
    </div>

    <!-- فرم ارسال نظر / ثبت نام در مسابقه -->
    <div class="bg-white shadow rounded-lg p-8 max-w-xl mx-auto mb-10">
        <?php if (!empty($success)) echo "<p class='text-green-600 mb-4'>{$success}</p>"; ?>
        <h2 class="text-2xl font-bold mb-4 text-center">ارسال نظر یا ثبت نام در مسابقه</h2>
        <form method="post">
            <input type="text" name="name" placeholder="نام و نام خانوادگی" required
                   class="w-full border p-2 mb-3 rounded">
            <select name="type" required class="w-full border p-2 mb-3 rounded">
                <option value="نظر">نظر</option>
                <option value="مسابقه">ثبت نام مسابقه</option>
            </select>
            <textarea name="message" placeholder="متن نظر یا اطلاعات ثبت نام" required
                      class="w-full border p-2 mb-3 rounded"></textarea>
            <button type="submit" name="submit_review"
                    class="bg-purple-600 text-white px-4 py-2 rounded w-full">ارسال</button>
        </form>
    </div>

    <!-- نمایش نظرات تأیید شده -->
    <div class="max-w-xl mx-auto">
        <h2 class="text-2xl font-bold mb-4">نظرات کاربران</h2>
        <?php
        $approvedReviews = array_filter($reviews, fn($r) => !empty($r['approved']));
        if (empty($approvedReviews)) {
            echo "<p class='text-gray-600'>فعلاً نظری تأیید نشده است.</p>";
        } else {
            foreach ($approvedReviews as $r) {
                echo "<div class='bg-white p-4 shadow rounded mb-3 border-l-4 border-green-500'>";
                echo "<b>" . htmlspecialchars($r['name']) . "</b> ";
                echo "<span class='text-gray-500 text-sm'>(" . htmlspecialchars($r['date']) . ")</span>";
                echo "<p class='mt-2'>" . nl2br(htmlspecialchars($r['message'])) . "</p>";
                echo "<span class='text-xs text-gray-500'>(" . htmlspecialchars($r['type']) . ")</span>";
                echo "</div>";
            }
        }
        ?>
    </div>

</div>

</body>
</html>
