<?php
// خواندن اخبار
$newsFile = "news.json";
$newsData = [];
if (file_exists($newsFile)) {
    $json = file_get_contents($newsFile);
    $newsData = json_decode($json, true);
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>مصلی امام خمینی (ره) میاندوآب</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-100">
<!-- Font: Vazirmatn (Farsi) -->    
<link rel="shortcut icon" href="image/logo-2.png" />
<!-- هدر با بنر و متن روی آن -->
<header class="relative w-full h-72 overflow-hidden">
    <!-- تصویر بنر -->
    <img src="https://images.irantarh.com/pr:sharp/rs:fit:0:0:0/plain/s3:/uploads/designs/1403/06/10/1725100204_PYIQFD.webp" 
         alt="بنر مصلی امام خمینی (ره) میاندوآب" 
         class="w-full h-full object-cover">
         

    <!-- متن و دکمه روی تصویر -->
    <div class="absolute inset-0 bg-black bg-opacity-40 flex items-center justify-between p-6">
        <div class="flex items-center gap-4">
            <img src="image/logo.png" alt="امام خمینی" class="w-14 h-14 rounded-full border-2 border-white">
            <div class="text-white">
                <h1 class="text-2xl font-bold">مصلی امام خمینی (ره)</h1>
                <p class="text-sm">شهر میاندوآب</p>
            </div>
        </div>
        <div class="flex gap-3">
            <!-- دکمه ارتباط با ما -->
            <a href="contact.php" class="bg-white text-green-700 px-4 py-2 rounded shadow hover:bg-green-100 transition">
                ارتباط با ما
            </a>
            <!-- دکمه ورود مدیریت -->
            <a href="admin.php" class="bg-white text-purple-700 px-4 py-2 rounded shadow hover:bg-purple-100 transition">
                ورود مدیریت
            </a>
        </div>
    </div>
</header>

<!-- بخش خوش‌آمدگویی -->
<section class="container mx-auto mt-10 text-center">
    <div class="bg-white shadow-xl rounded-xl p-8">
        <h2 class="text-2xl font-bold mb-3">به مصلی امام خمینی (ره) میاندوآب خوش آمدید</h2>
        <p class="text-gray-600">محلی مقدس برای اقامه نماز، برگزاری مراسم مذهبی و ترویج معارف قرآن کریم</p>
    </div>
</section>

<!-- بخش خدمات -->
<section class="container mx-auto mt-10 grid md:grid-cols-3 gap-6">
    <div class="bg-white shadow rounded-xl p-6 border-r-4 border-green-500">
        <h3 class="text-xl font-bold mb-2">نماز جماعت</h3>
        <p class="text-gray-600">برگزاری نماز جماعت در اوقات شرعی</p>
    </div>
    <div class="bg-white shadow rounded-xl p-6 border-r-4 border-blue-500">
        <h3 class="text-xl font-bold mb-2">کلاس‌های آموزش قرآن کریم</h3>
        <p class="text-gray-600">آموزش تلاوت، تجوید و تفسیر قرآن کریم</p>
    </div>
    <div class="bg-white shadow rounded-xl p-6 border-r-4 border-purple-500">
        <h3 class="text-xl font-bold mb-2">مراسم مذهبی و فرهنگی</h3>
        <p class="text-gray-600">برگزاری مراسم مناسبتی و فعالیت‌های فرهنگی در شهر میاندوآب</p>
    </div>
</section>

<section class="w-full bg-gray-50 py-10 px-4">
    <div class="max-w-7xl mx-auto">
        <h2 class="text-2xl font-bold mb-6 border-b-4 border-green-600 inline-block pb-2">
            اخبار و مسابقه‌ها
        </h2>

        <div class="flex flex-wrap justify-start gap-6">
            <?php foreach ($newsData as $i => $news): ?>
                <div class="bg-white rounded-xl shadow-md overflow-hidden w-80 border border-gray-200 hover:shadow-xl transition-all duration-300">
                    
                    <?php if (!empty($news['image'])): ?>
                        <img src="<?php echo htmlspecialchars($news['image']); ?>" alt="عکس خبر" class="w-full h-44 object-cover">
                    <?php endif; ?>

                    <div class="p-4">
                        <h3 class="font-semibold text-lg text-gray-800 mb-2">
                            <?php echo htmlspecialchars($news['title']); ?>
                        </h3>

                        <!-- متن کوتاه با ارتفاع محدود -->
                        <div id="text-<?php echo $i; ?>" class="text-gray-700 text-sm text-justify leading-relaxed max-h-28 overflow-hidden">
                            <?php echo nl2br(htmlspecialchars($news['content'])); ?>
                        </div>

                        <button 
                            id="btn-<?php echo $i; ?>"
                            onclick="toggleText(<?php echo $i; ?>)" 
                            class="text-green-700 text-sm mt-2 hover:underline hidden">
                            ادامه مطلب ▾
                        </button>

                        <span class="block text-xs text-gray-500 mt-3 text-left">
                            <?php echo htmlspecialchars($news['date']); ?>
                        </span>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<script>
function toggleText(id) {
    const textDiv = document.getElementById('text-' + id);
    const btn = document.getElementById('btn-' + id);

    if (textDiv.style.maxHeight === 'none') {
        textDiv.style.maxHeight = '7rem'; // محدودیت اولیه
        btn.textContent = 'ادامه مطلب ▾';
    } else {
        textDiv.style.maxHeight = 'none';
        btn.textContent = 'بستن ▲';
    }
}

// بررسی ارتفاع متن‌ها هنگام بارگذاری صفحه
window.addEventListener('DOMContentLoaded', () => {
    <?php foreach ($newsData as $i => $news): ?>
        const textDiv<?php echo $i; ?> = document.getElementById('text-<?php echo $i; ?>');
        const btn<?php echo $i; ?> = document.getElementById('btn-<?php echo $i; ?>');

        // اگر متن بلندتر از max-height هست، دکمه نمایش داده میشه
        if(textDiv<?php echo $i; ?>.scrollHeight > textDiv<?php echo $i; ?>.clientHeight){
            btn<?php echo $i; ?>.classList.remove('hidden');
        }
    <?php endforeach; ?>
});
</script>


<!-- فوتر -->
<footer class="bg-purple-800 text-white mt-16 p-6 text-center">
    <p>© 2025 - تمامی حقوق برای مصلی امام خمینی (ره) میاندوآب محفوظ است</p>
</footer>
</body>
</html>
